<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Empresa;

class EmpresaController extends Controller
{
    public function index() {
        return response()->json(Empresa::all());
    }

    public function store(Request $request) {
        $data = $request->validate([
            'nome' => 'required|string|unique:empresas',
            'email' => 'required|email|unique:empresas',
            'telefone' => 'nullable|string',
            'endereco' => 'nullable|string'
        ]);
        $empresa = Empresa::create($data);
        return response()->json($empresa, 201);
    }

    public function update(Request $request, Empresa $empresa) {
        $data = $request->validate([
            'nome' => 'sometimes|string|unique:empresas,nome,' . $empresa->id,
            'email' => 'sometimes|email|unique:empresas,email,' . $empresa->id,
            'telefone' => 'nullable|string',
            'endereco' => 'nullable|string'
        ]);
        $empresa->update($data);
        return response()->json($empresa);
    }

    public function destroy(Empresa $empresa) {
        $empresa->delete();
        return response()->json(null, 204);
    }
}
